% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_spec.R
\docType{methods}
\name{spec-methods}
\alias{spec-methods}
\alias{lines.spec}
\alias{spec_details}
\alias{as.data.frame.spec}
\alias{as.matrix.spec}
\alias{as.list.spec}
\title{Generic methods for objects with class \code{'spec'}}
\usage{
\method{lines}{spec}(x, y = NULL, type = "l", ...)

spec_details(x, ...)

\method{as.data.frame}{spec}(x, ...)

\method{as.matrix}{spec}(x, ...)

\method{as.list}{spec}(x, ...)
}
\arguments{
\item{x}{a \code{'spec'} object}

\item{y}{optional coordinate vector for the y-axis}

\item{type}{character; the type of plot}

\item{...}{optional arguments}
}
\description{
Generic methods for objects with class \code{'spec'}
}
\details{
Objects with class \code{'spec'} are simply lists with spectral estimates and parameters 
\code{as.data.frame} converts the list into a \code{'data.frame'} with individual
columns for the frequency, PSD, and taper vectors; 
all other information will be retained as a list in the attributes.
}
\examples{
\dontrun{#REX
library(psd)

##
## Objects with class 'spec'
##

set.seed(1234)
xn <- rnorm(10)
x <- spectrum(xn, plot=FALSE)
xc <- psdcore(xn)

xdf <- as.data.frame(x)
str(xdf)
is.tapers(xdf$taper)

xdfc <- as.data.frame(xc)
str(xdfc)
is.tapers(xdfc$taper)

}#REX
}
\author{
A.J. Barbour
}
