% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{integrate_bivnorm}
\alias{integrate_bivnorm}
\title{Bivariate normal integration models for the missing S(1)}
\usage{
integrate_bivnorm(x = "S.1", mu = c(0, 0), sd = c(1, 1), rho = 0.2)
}
\arguments{
\item{x, }{expression identifying the variable to be integrated. Typically this is S.1 or S.0}

\item{mu, }{means of the pair of surrogates, missing one first}

\item{sd, }{standard deviations of the pair, missing one first}

\item{rho, }{the correlation between X1 and X2}
}
\description{
This model assumes that the pair [S(1), W] is bivariate normal, where W is
the BIP. The means, standard deviations, and correlation are estimated or
fixed before calling this function. Then the conditional normal formula is
applied in order to get the distribution of S(1) | W. That distribution is
used to integrate over the missing S(1) values. This method requires a BIP in the
design.
}

