% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{printAovMeans}
\alias{printAovMeans}
\title{printAovMeans}
\usage{
printAovMeans(..., caption = "Mean", digits = 3, dv = "ms")
}
\arguments{
\item{...}{Output from aov or ezANOVA (NB. ezANOVA must be called with detailed = TRUE)}

\item{caption}{Title for the table}

\item{digits}{Number of digits to round to}

\item{dv}{Name of the dependent variable (e.g., "ms", "\%")}
}
\value{
character
}
\description{
Returns Latex formatted table of marginal means from model.tables.
Uses printTable (xtable) latex package with some basic defaults.
For more examples, see R package xtable
}
\examples{
# Example 1:
# create dataframe
dat <- createDF(nVP = 6, nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp comp"   = c(500, 150, 100),
                                "Comp incomp" = c(520, 150, 100)))

aovRT <- aov(RT ~ Comp + Error(VP/(Comp)), dat)
aovRT <- aovTable(aovRT)
printAovMeans(aovRT, digits = 3, dv = "ms")  # latex formatted

# or using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp), return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)
printAovMeans(aovRT, digits = 0, dv = "ms")  # latex formatted

}
