% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{statStrT}
\alias{statStrT}
\title{statStrT}
\usage{
statStrT(tObj)
}
\arguments{
\item{tObj}{The returned object from a call to t.test}
}
\value{
character
}
\description{
Returns required Latex formatted string T-test required for R/Knitr integration.
For example, \emph{t}(11) = 3.45, \emph{p} < 0.05.
Returns values to 2 sig decimal places and < 0.01, < 0.001 for p values.
}
\examples{
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) levels
dat <- createDF(nVP = 50,
                nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp comp"   = c(500, 100, 100),
                                "Comp incomp" = c(600, 100, 100)))

tObj <- t.test(dat$RT[dat$Comp == "incomp"],
               dat$RT[dat$Comp == "comp"],
               paired = TRUE)

statStrT <- statStrT(tObj)

}
