% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_anova.R
\name{anova.ma_psychmeta}
\alias{anova.ma_psychmeta}
\title{Wald-type tests for moderators in psychmeta meta-analyses}
\usage{
\method{anova}{ma_psychmeta}(
  object,
  ...,
  analyses = "all",
  moderators = NULL,
  L = NULL,
  ma_obj2 = NULL,
  ma_method = c("bb", "ic", "ad"),
  correction_type = c("ts", "vgx", "vgy"),
  conf_level = NULL
)
}
\arguments{
\item{object}{A psychmeta meta-analysis object.}

\item{...}{Additional arguments.}

\item{analyses}{Which analyses to to test moderators for? Can be either \code{"all"} to test moderators for all meta-analyses in the object (default) or a list containing one or more of the arguments \code{construct}, \code{construct_pair}, \code{pair_id}, \code{k_min}, and \code{N_min}. See \code{\link[=filter_ma]{filter_ma()}} for details. Note that \code{analysis_id} should not be used. If \code{k_min} is not supplied, it is set to 2.}

\item{moderators}{A character vector of moderators to test. If \code{NULL}, all categorical moderators are tested.}

\item{L}{A named list with with elements specifying set of linear contrasts for each variable in \code{moderators}. (Not yet implemented.)}

\item{ma_obj2}{A second psychmeta meta-analysis object to compare to \code{object} (Not yet implemented.)}

\item{ma_method}{Meta-analytic methods to be included. Valid options are: "bb", "ic", and "ad"}

\item{correction_type}{Types of meta-analytic corrections to be incldued. Valid options are: "ts", "vgx", and "vgy"}

\item{conf_level}{Confidence level to define the width of confidence intervals (defaults to value set when \code{object} was fit)}
}
\value{
An object of class \code{anova.ma_psychmeta}. A tibble with a row for each construct pair in \code{object} and a column for each moderator tested. Cells lists of contrasts tested.
}
\description{
This function computes Wald-type pairwise comparisons for each level of
categorical moderators for an \code{ma_psychmeta} object, as well as an ombnibus
one-way ANOVA test (equal variance not assumed).

Currently, samples across moderator levels are assumed to be indepdent.
}
\note{
Currently, only simple (single) categorical moderators (one-way ANOVA) are supported.
}
\examples{
ma_obj <- ma_r(rxyi, n, construct_x = x_name, construct_y = y_name,
moderators = moderator, data = data_r_meas_multi)

anova(ma_obj)
}
