% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_u.R
\name{estimate_u}
\alias{estimate_u}
\title{Estimate u ratios from available artifact information}
\usage{
estimate_u(
  measure_id = NULL,
  sdi = NULL,
  sda = NULL,
  rxxi = NULL,
  rxxa = NULL,
  item_ki = NULL,
  item_ka = NULL,
  n = NULL,
  meani = NULL,
  sr = NULL,
  rxya_est = NULL,
  data = NULL
)
}
\arguments{
\item{measure_id}{Vector of measure identifiers.}

\item{sdi}{Scalar or vector containing restricted standard deviation(s).}

\item{sda}{Scalar or vector containing unrestricted standard deviation(s).}

\item{rxxi}{Scalar or vector containing restricted reliability coefficient(s).}

\item{rxxa}{Scalar or vector containing unrestricted reliability coefficient(s).}

\item{item_ki}{Scalar or vector containing the number of items used in measures within samples.}

\item{item_ka}{Scalar or vector indicating the number of items toward which reliability estimates should be adjusted using the Spearman-Brown formula.}

\item{n}{Vector of sample sizes.}

\item{meani}{Vector of sample means.}

\item{sr}{Vector of selection ratios (used only when no other useable u-ratio inputs are available).}

\item{rxya_est}{Vector of estimated unrestricted correlations between the selection mechanism and the variable of interest (used only when \code{sr} is used).}

\item{data}{Optional data frame containing any or all information for use in other arguments.}
}
\value{
A vector of estimated u ratios.
}
\description{
Uses information about standard deviations, reliability estimates, and selection ratios to estimate u ratios.
Selection ratios are only used to estimate u when no other information is available, but estimates of u computed from SDs and reliabilities will be averaged to reduce error.
}
\examples{
sdi <- c(1.4, 1.2, 1.3, 1.4)
sda <- 2
rxxi <- c(.6, .7, .75, .8)
rxxa <- c(.9, .95, .8, .9)
item_ki <- c(12, 12, 12, NA)
item_ka <- NULL
n <- c(200, 200, 200, 200)
meani <- c(2, 1, 2, 3)
sr <- c(.5, .6, .7, .4)
rxya_est <- .5

## Estimate u from standard deviations only:
estimate_u(sdi = sdi, sda = sda)

## Estimate u from incumbent standard deviations and the
## mixture standard deviation:
estimate_u(sdi = sdi, sda = "mixture", meani = meani, n = n)

## Estimate u from reliability information:
estimate_u(rxxi = rxxi, rxxa = rxxa)

## Estimate u from both standard deviations and reliabilities:
estimate_u(sdi = sdi, sda = sda, rxxi = rxxi, rxxa = rxxa,
           item_ki = item_ki, item_ka = item_ka, n = n,
           meani = meani, sr = sr, rxya_est = rxya_est)

estimate_u(sdi = sdi, sda = "average", rxxi = rxxi, rxxa = "average",
           item_ki = item_ki, item_ka = item_ka, n = n, meani = meani)

## Estimate u from selection ratios as direct range restriction:
estimate_u(sr = sr)

## Estimate u from selection ratios as indirect range restriction:
estimate_u(sr = sr, rxya_est = rxya_est)
}
