% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetVapPresFromHumRatio}
\alias{GetVapPresFromHumRatio}
\title{Return vapor pressure given humidity ratio and pressure.}
\usage{
GetVapPresFromHumRatio(HumRatio, Pressure)
}
\arguments{
\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]
}
\description{
Return vapor pressure given humidity ratio and pressure.
}
\examples{
SetUnitSystem("IP")
GetVapPresFromHumRatio(seq(0.02, 0.03, 0.001), 14.175)

SetUnitSystem("SI")
GetVapPresFromHumRatio(seq(0.02, 0.03, 0.001), 95461)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 20 solved for pw
}
