% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTWetBulbFromRelHum}
\alias{GetTWetBulbFromRelHum}
\title{Return wet-bulb temperature given dry-bulb temperature, relative humidity, and pressure.}
\usage{
GetTWetBulbFromRelHum(TDryBulb, RelHum, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{RelHum}{A numeric vector of relative humidity in range [0, 1]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return wet-bulb temperature given dry-bulb temperature, relative humidity, and pressure.
}
\examples{
SetUnitSystem("IP")
GetTWetBulbFromRelHum(80:100, 0.2, 14.696)

SetUnitSystem("SI")
GetTWetBulbFromRelHum(25:40, 0.2, 101325.0)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
}
