% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddG.R
\name{foldx.assembly}
\alias{foldx.assembly}
\title{Compute Assembly Free Energy}
\usage{
foldx.assembly(pdb, mol1, mol2, pH = 7, I = 0.05)
}
\arguments{
\item{pdb}{the 4-letter identifier of a PDB structure or the path to a PDB file.}

\item{mol1}{molecule or group of molecules interacting with mol2 (see details)}

\item{mol2}{molecule or group of molecules interacting with mol1 (see details)}

\item{pH}{a numeric value between 0 and 14.}

\item{I}{a value indicating the molar ionic strength.}
}
\value{
The function returns a dataframe with the residues that make up the interface between mol1 and mol2, as well as the change in Gibbs free energy, DG, of the assembly process for the requested subunits.
}
\description{
Computes changes in the Gibbs free energy of the assembly process of a protein.
}
\details{
This function implements the FoldX's command 'AnalyseComplex', which allows to determine the interaction energy between two molecules or two groups of molecules. For instance, if in a dimeric protein, formed by chain A and B, we may set: mol1 = 'A', mol2 = 'B'. If we are dealing with a trimer, we may set: mol1 = 'A', mol2: 'AB'.
}
\examples{
\dontrun{foldx.assembly(pdb = '1sev', mol1 = 'A', mol2 = 'B')}
}
\references{
Schymkowitz et al (2005) Nucl. Ac. Res. 33:W382-W388.
}
\seealso{
foldx.stab()
}
\author{
Juan Carlos Aledo
}
