% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald-test.R
\name{wald.test}
\alias{wald.test}
\title{Wald test for regression coefficients}
\usage{
wald.test(obj, L, k = NULL)
}
\arguments{
\item{obj}{an object of class \code{ptglmm} (obtained from 
\code{ptmixed} or \code{nbmixed}) or \code{ptglm} (obtained from 
\code{ptglm} or \code{nbglm})}

\item{L}{a matrix used to define the hypothesis to test,
in the form $L b = k$}

\item{k}{a vector used to define the hypothesis to test,
in the form $L b = k$. Default is a null vector ($L b = 0$)}
}
\value{
A data frame with the result of the test
}
\description{
Compute a multivariate Wald test for one of the following
models: Poisson-Tweedie GLMM, negative binomial GLMM, 
Poisson-Tweedie GLM, negative binomial GLM. The null
hypothesis has to be specified in the (matrix) form
$L b = k$
}
\examples{
\donttest{
# generate data
set.seed(1234)
n = 50
group = rep(c(0,1), each = n/2)
age = rpois(n, lambda = 5)
beta = c(3, 0.05, 0.2, 0.03)
X = model.matrix(~group + age + age*group)
mu = exp(X \%*\% beta)
y = rep(NA, n) 
library(tweeDEseq)
for (i in 1:n) y[i] = rPT(1, mu = mu[i], D = 2, a = 0, max = 1000)
dataset = data.frame(y, group, age)
rm(list = setdiff(ls(), 'dataset'))
# estimate a negative binomial glm
fit1 = nbglm(formula = y ~ group + age + age*group, data = dataset)
# define L for beta2 = beta4 = 0
L = matrix(0, nrow = 2, ncol = 4)
L[1, 2] = L[2, 4] = 1              
# compute multivariate Wald test
wald.test(obj = fit1, L = L, k = NULL)
}
}
\author{
Mirko Signorelli
}
