% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_wls}
\alias{alpha_wls}
\title{Estimating the Shape Parameter by Weighted Least Squares Method (WLS)}
\usage{
alpha_wls(dat)
}
\arguments{
\item{dat}{vector of observations}
}
\value{
A list of the following form:
\describe{
  \item{shape}{Estimate of the shape parameter of the data}
  \item{scale}{Estimate of the scale parameter of the data (which is taken
  to be the minimum of the data)}
}
}
\description{
This function uses the Weighted Least Squares Method (WLS) to estimate the
\code{shape} parameter of a given set of data. (Nair et al. 2019)
}
\examples{
x <- generate_pareto(10000, 5, 2)
alpha_percentile(x)

}
\references{
Nair J, Wierman A, Zwart B (2019). "The Fundamentals Of Heavy Tails: 
Properties, Emergence, And Identification." 
http://users.cms.caltech.edu/ adamw/heavytails.html.
}
