% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route-types.R
\name{cached_route_types}
\alias{cached_route_types}
\title{Retrieve route types, using cached values if possible}
\usage{
cached_route_types(
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A named integer vector in which the values are the route type
descriptions, and the names of the vector are the route type numbers.
}
\description{
Route types will change extraordinarily rarely --- this would require PTV to
add a new route type akin to "train" or "bus". To avoid querying the API too
much, we prefer to use cached values for route type translation wherever
possible. This function effectively wraps \code{route_types}, returning cached
results if possible or caching results otherwise. Note that if a user
specifically calls \code{route_types} then we do \emph{not} return cached results.

We use the \code{pkg_env} as a cache, which is an environment created on package
load. This is not truly private --- users could still access this as an
internal value. But it's effectively "out of the way".
}
\keyword{internal}
