% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-possibly.R
\name{possibly}
\alias{possibly}
\title{Wrap a function to return a value instead of an error}
\usage{
possibly(.f, otherwise = NULL, quiet = TRUE)
}
\arguments{
\item{.f}{A function to modify, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. No longer recommended.
}}

\item{otherwise}{Default value to use when an error occurs.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them
as they occur?}
}
\value{
A function that takes the same arguments as \code{.f}, but returns
a different value, as described above.
}
\description{
Create a modified version of \code{.f} that return a default value (\code{otherwise})
whenever an error occurs.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
# To replace errors with a default value, use possibly().
list("a", 10, 100) |>
  map_dbl(possibly(log, NA_real_))

# The default, NULL, will be discarded with `list_c()`
list("a", 10, 100) |>
  map(possibly(log)) |>
  list_c()
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{partial}()},
\code{\link{quietly}()},
\code{\link{safely}()},
\code{\link{slowly}()}
}
\concept{adverbs}
