% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_bar.R
\name{progress_bar}
\alias{progress_bar}
\title{Create a R6 progress bar directly}
\usage{
progress_bar(total, title = "Progress", ...,
  type = getOption("progress.type", infer_type()))
}
\arguments{
\item{total}{the total number of elements}

\item{title}{the title of the progress bar}

\item{...}{passed on to the specific constructor determined by type.}

\item{type}{the type of progress bar to create as a string, or an
\code{R6ClassGenerator} object for a class that inherits from
the "R6 Progress Base Class".}
}
\description{
Create a R6 progress bar directly
}
\examples{

\donttest{
pb_win <- progress_bar(100, "Windows Progress", type = 'win')
}
pb_txt <- progress_bar(100, "Text Progress", type = 'txt')
pb_txt$init() # starts the timer and shows the bar.
pb_txt$step() # take 1 step update progress bar.
pb_txt$step(25) # take 24 steps at one time
pb_txt$term() # do finishing tasks for progress bar.

# The following use Unicode characters and may not work with all fonts.
# DejaVu Sans Mono is one font which supports all the characters used
pb_bar   <- progress_bar(100, "Bar Progress", type = 'bar')
pb_line  <- progress_bar(100, "Line Progress", type = 'line')
pb_box   <- progress_bar(100, "Box Progress", type = 'box')
pb_block <- progress_bar(100, "Block Progress", type = 'block')

}
