% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwigls2.R
\name{pwigls2}
\alias{pwigls2}
\title{Fit Weighted Linear Multilevel Model}
\usage{
pwigls2(formula, data = NULL, wj, wij)
}
\arguments{
\item{formula}{a two-sided linear formula object describing both the fixed-effects and random-effects part of the model, with the response on the left of a ~ operator and the terms, separated by + operators, on the right. Random-effects terms are distinguished by vertical bars (|) separating expressions for design matrices from grouping factors.}

\item{data}{an optional data frame containing the variables in \code{formula}. If not found in data, the variables are taken from the environment of \code{formula} (if specified as a formula) or from the parent frame (if specified as a character vector).}

\item{wj}{a vector of sampling weights for level two units. Level two units are selected with inclusion probabilities. Then, sampling weights for the level two units are defined as the inverse of these probabilities.}

\item{wij}{a vector of sampling weights for level one units. After selecting a level two unit, level one units belonging to them are selected with inclusion probabilities. Then, sampling weights for the level one units are defined as the inverse of these probabilities.}
}
\value{
Estimated list of estimators
}
\description{
Fit a probability-weighted two-level linear model with unequal selection probabilities at each level, via IGLS algorithm.
}
\details{
Follows estimation process described in Pfeffermann et al. (1998). Uses probability-weighted IGLS with scaled weights.
}
\examples{
data(dataw1)
pwigls2( Y ~ X1 + X2 + (1 | PSU), data = dataw1, wj, wi_j)

}
\references{
D. Pfeffermann; C. J. Skinner; D. J. Holmes; H. Goldstein; J. Rasbash, 2008,
Weighting for Unequal Selection Probabilities in Multilevel Models
Journal of the Royal Statistical Society. Series B (Statistical Methodology),
Vol. 60, No. 1. (1998), pp. 23-40.
}
