% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetHITTypeNotification.R
\name{SetHITTypeNotification}
\alias{SetHITTypeNotification}
\alias{setnotification}
\title{Configure a HITType Notification}
\usage{
SetHITTypeNotification(hit.type, notification = NULL, active = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{hit.type}{A character string specifying the HITTypeId of the HITType
for which notifications are being configured.}

\item{notification}{An optional dictionary object Notification structure (e.g., returned by
\code{\link{GenerateNotification}}).}

\item{active}{A logical indicating whether the Notification is active or
inactive.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing details of the Notification and whether or
not the request was successfully executed by MTurk.

Once configured, events will trigger a side effect in the form of a
notification sent to the specified transport (either an email address or SQS
queue). That notification will contain the following details:
\code{EventType}, \code{EventTime}, \code{HITTypeId}, \code{HITId}, and (if
applicable) \code{AssignmentId}.

Note that the 'Notification' column in this dataframe is a dictionary object
coerced into a character type. This cannot be used again directly as a notification
parameter, but it can be used to re-construct the dictionary object.
}
\description{
Configure a notification to be sent when specific actions occur for the
specified HITType.
}
\details{
Configure a notification to be sent to the requester whenever an event
(specified in the \code{Notification} object) occurs. This is useful, for
example, to enable email notifications about when assignments are submitted
or HITs are completed, or for other HIT-related events.

Email notifications are useful for small projects, but configuring
notifications to use the Amazon Simple Queue Service (SQS) is more reliable
for large projects and allows automated processing of notifications.

\code{setnotification()} is an alias.
}
\examples{

\dontrun{
# setup email notification
hittype <- RegisterHITType(title = "10 Question Survey",
                description = "Complete a 10-question survey",
                reward = ".20",
                duration = seconds(hours = 1),
                keywords = "survey, questionnaire, politics")

a <- GenerateNotification("user@gmail.com", "Email", "AssignmentAccepted")
SetHITTypeNotification(hit.type = hittype$HITTypeId,
                       notification = a,
                       active = TRUE)

# send test notification
SendTestEventNotification(a, test.event.type = "AssignmentAccepted")
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html}{API Reference: Operation}

\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMechanicalTurkRequester/Concepts_NotificationsArticle.html}{API Reference: Concept}
}
\seealso{
\code{\link{GenerateNotification}}

\code{\link{SendTestEventNotification}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Notifications}
