% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetReviewableHITs.R
\name{GetReviewableHITs}
\alias{GetReviewableHITs}
\alias{reviewable}
\title{Get Reviewable HITs}
\usage{
GetReviewableHITs(hit.type = NULL, status = "Reviewable",
  results = as.integer(100), pagetoken = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{hit.type}{An optional character string containing a HITTypeId to
consider when looking for reviewable HITs.}

\item{status}{An optional character string of either \dQuote{Reviewable} or
\dQuote{Reviewing} limiting the search to HITs of with either status.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing HITIds and Requester Annotations.
}
\description{
Get HITs that are currently reviewable.
}
\details{
A simple function to return the HITIds of HITs currently in
\dQuote{Reviewable} or \dQuote{Reviewing} status. To retrieve additional
details about each of these HITs, see \code{\link{GetHIT}}. This is an
alternative to \code{\link{SearchHITs}}.

\code{reviewable()} is an alias.
}
\examples{

\dontrun{
GetReviewableHITs()
}

}
\references{
\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetReviewableHITsOperation.html}{API Reference}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{HITs}
