% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_csv.R
\name{load_csv}
\alias{load_csv}
\title{Load a CSV file with automatic separator detection}
\usage{
load_csv(filepath, dec = ".", encoding = getOption("encoding"))
}
\arguments{
\item{filepath}{A string specifying the path to the CSV file (.csv extension).}

\item{dec}{A character specifying the decimal separator to use.
Default is "." (period).}

\item{encoding}{A string specifying the encoding of the file. Default is the native
system encoding set by \code{getOption("encoding")}. For more details on encoding
see \link[base]{file}.}
}
\value{
A data frame containing the data from the CSV file.
}
\description{
Reads CSV files containing more than one column of
data. It automatically detects common separators (i.e., comma, semicolon, tab),
while allowing users to specify encoding and decimal separators as required.
}
\examples{
# file path
fpath <- system.file("extdata", "data_ex.csv", package="qPRAentry")
# Load a CSV file
df <- load_csv(fpath) 
head(df) # value as character
# Load a CSV file with comma separated decimals
df <- load_csv(fpath, dec = ",") # value as numeric

}
