% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_fields.R
\name{get_fields}
\alias{get_fields}
\title{Get all fields in a table}
\usage{
get_fields(
  subdomain,
  auth,
  table_id,
  agent = NULL,
  include_props = T,
  include_perms = F
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{table_id}{Character vector with one element. Found in the URL of a
Quickbase table between /db/ and ?}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}

\item{include_props}{Logical. Includes field properties if true.}

\item{include_perms}{Logical. Includes custom field permissions if true. Only
returns data if custom permissions exist for at least 1 field in the table.}
}
\value{
A tibble.
}
\description{
Get metadata for all fields in a table.
}
\examples{
\dontrun{
   get_fields(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              table_id = "bsf5hphe5")
}
}
