\name{cm_df2long}
\alias{cm_df2long}
\title{Transform Codes to Start-End Durations}
\usage{
cm_df2long(df.temp.obj, v.name = "variable", list.var = TRUE,
  code.vars = NULL, no.code = NA, add.start.end = TRUE,
  repeat.vars = NULL, rev.code = FALSE)
}
\arguments{
  \item{df.temp.obj}{A character vector of names of
  object(s) created by \code{\link{cm_df.temp}}, a list of
  \code{\link{cm_df.temp}} created objects or a data frame
  created by \code{\link{cm_df.temp}}.}

  \item{v.name}{An optional name for the column created for
  the list.var argument.}

  \item{list.var}{logical.  If \code{TRUE} creates a column
  for the data frame created by each time.list.}

  \item{code.vars}{A character vector of code variables.
  If \code{NULL} uses all variables from the first column
  after the column named word.num.}

  \item{no.code}{The value to assign to no code; default is
  \code{NA}.}

  \item{add.start.end}{logical.  If \code{TRUE} adds a
  column for start and end times.}

  \item{repeat.vars}{A character vector of repeated/stacked
  variables.  If \code{NULL} uses all non code.vars
  variables.}

  \item{rev.code}{logical.  If \code{TRUE} reverses the
  order of \code{code.vars} and \code{no.code} variables.}
}
\value{
Generates a data frame of start and end times for each
code.
}
\description{
Transforms the range coding structure(s) from
\code{\link[qdap]{cm_df.temp}} (in list format) into a data
frame of start and end durations in long format.
}
\examples{
\dontrun{
codes <- qcv(dc, sf, wes, pol, rejk, lk, azx, mmm)
x1 <- cm_df.temp(DATA, "state", codes)
head(x1)

#empty code matrix
out1 <- cm_df2long(x1,  code.vars = codes)
head(out1, 15)

#fill it randomly
x1[, 7:14] <- lapply(7:14,  function(i) sample(0:1, nrow(x1), TRUE))
out2 <- cm_df2long(x1,  code.vars = codes)
head(out2, 15)
plot(out2)
}
}
\references{
Miles, M. B. & Huberman, A. M. (1994). An expanded
sourcebook: Qualitative data analysis. 2nd ed. Thousand
Oaks, CA: SAGE Publications.
}
\seealso{
\code{\link{cm_time2long}}, \code{\link{cm_range2long}},
\code{\link{cm_df.temp}}
}
\keyword{coding,}
\keyword{span}
\keyword{time}

