\name{summary.cmspans}
\alias{summary.cmspans}
\title{Summarize a cmspans object}
\usage{
\method{summary}{cmspans}(object, grouping.var = NULL, rm.var = NULL,
  total.span = TRUE, aggregate = FALSE, percent = TRUE, digits = 2, ...)
}
\arguments{
  \item{object}{The cmspans object}

  \item{grouping.var}{The grouping variables. Also takes a
  single grouping variable or a list of 1 or more grouping
  variables.}

  \item{rm.var}{An optional single vector or list of 1 or 2
  of repeated measures to aggregate by.}

  \item{total.span}{logical or an option list of vectors
  (length 1 or 2) of the total duration of the event.  If
  \code{FALSE} the "total" column is divided by the sum of
  the total duration for all codes in that rm.var to arrive
  at "total_percent".  If \code{TRUE} and object is from
  \code{cm_time2long} the difference for the time span from
  the \strong{transcript_time_span} of the list used in
  \code{cm_time2long} are utilized to divide the "total"
  column. The user may also provide a list of vectors with
  each vector representing a single total time duration or
  provide the start and end time of the event.  The user
  may give input in numeric seconds or in character
  "hh:mm:ss" form.}

  \item{aggregate}{logical.  If \code{TRUE} the output will
  be aggregated (i.e., the output will collapse the
  \code{rm.var}).}

  \item{percent}{logical.  If \code{TRUE} output given as
  percent.  If \code{FALSE} the output is proportion.}

  \item{digits}{Integer; number of decimal places to round
  when printing.}

  \item{\ldots}{Other argument passed to \code{qheat} in
  plot (ignored in summary).}
}
\description{
Summarize a cmspans object
}
\examples{
\dontrun{
## Example 1
foo <- list(
    person_greg = qcv(terms='7:11, 20:24, 30:33, 49:56'),
    person_researcher = qcv(terms='42:48'),
    person_sally = qcv(terms='25:29, 37:41'),
    person_sam = qcv(terms='1:6, 16:19, 34:36'),
    person_teacher = qcv(terms='12:15'),
    adult_0 = qcv(terms='1:11, 16:41, 49:56'),
    adult_1 = qcv(terms='12:15, 42:48'),
    AA = qcv(terms="1"),
    BB = qcv(terms="1:2, 3:10, 19"),
    CC = qcv(terms="1:9, 100:150")
)

foo2  <- list(
    person_greg = qcv(terms='7:11, 20:24, 30:33, 49:56'),
    person_researcher = qcv(terms='42:48'),
    person_sally = qcv(terms='25:29, 37:41'),
    person_sam = qcv(terms='1:6, 16:19, 34:36'),
    person_teacher = qcv(terms='12:15'),
    adult_0 = qcv(terms='1:11, 16:41, 49:56'),
    adult_1 = qcv(terms='12:15, 42:48'),
    AA = qcv(terms="40"),
    BB = qcv(terms="50:90"),
    CC = qcv(terms="60:90, 100:120, 150"),
    DD = qcv(terms="")
)

v <- cm_2long(foo, foo2, v.name = "time")
plot(v)
summary(v)
plot(summary(v))

## Example 2
x <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00,
        9.00, 1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)
z <-cm_2long(x)

summary(z)
summary(z, total.span = FALSE)
summary(z, total.span = c(0, 3333))
summary(z, total.span = c("00:01:00", "03:02:00"))
plot(summary(z))

## suppress printing measurement units
suppressMessages(print(summary(z)))

## remove print method
as.data.frame(z_unclass)
}
}
\seealso{
\code{\link[qdap]{plot.sum_cmspans}}
}

