% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarity.R
\name{plot.polarity}
\alias{plot.polarity}
\title{Plots a polarity Object}
\usage{
\method{plot}{polarity}(x, bar.size = 5, low = "blue", mid = "grey99",
  high = "red", ave.polarity.shape = "+", alpha = 1/4, shape = 19,
  point.size = 2.5, jitter = 0.1, nrow = NULL, na.rm = TRUE,
  order.by.polarity = TRUE, plot = TRUE, error.bars = TRUE,
  error.bar.height = 0.5, error.bar.size = 0.5, error.bar.color = "black",
  ...)
}
\arguments{
\item{x}{The polarity object.}

\item{bar.size}{The size of the bars used in the Gantt plot.}

\item{low}{The color to be used for lower values.}

\item{mid}{The color to be used for mid-range values (default is a less 
striking color).}

\item{high}{The color to be used for higher values.}

\item{ave.polarity.shape}{The shape of the average polarity score used in the 
dot plot.}

\item{alpha}{Transparency level of points (ranges between 0 and 1).}

\item{shape}{The shape of the points used in the dot plot.}

\item{point.size}{The size of the points used in the dot plot.}

\item{jitter}{Amount of vertical jitter to add to the points.}

\item{nrow}{The number of rows in the dotplot legend (used when the number of 
grouping variables makes the legend too wide).  If \code{NULL} no legend if 
plotted.}

\item{na.rm}{logical. Should missing values be removed?}

\item{order.by.polarity}{logical.  If \code{TRUE} the group polarity plot 
will be ordered by average polarity score, otherwise alphabetical order is 
assumed.}

\item{plot}{logical.  If \code{TRUE} the plot will automatically plot.
The user may wish to set to \code{FALSE} for use in knitr, sweave, etc.
to add additional plot layers.}

\item{error.bars}{logical.  If \code{TRUE} error bars are added to the 
polarity dot plot using the standard error of the mean polarity score.}

\item{error.bar.height}{The height of the error bar ends.}

\item{error.bar.size}{The size/thickness of the error bars.}

\item{error.bar.color}{The color of the error bars.  If \code{NULL} each 
bar will be colored by grouping variable.}

\item{\ldots}{ignored}
}
\value{
Invisibly returns the \code{ggplot2} objects that form the larger 
plot.
}
\description{
Plots a polarity object as a heat map Gantt plot with polarity over 
time (measured in words) and polarity scores per sentence.  In the dotplot 
plot the black dots are the average polarity per grouping variable.
}

