% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_caps_phrase}
\alias{rm_caps_phrase}
\title{Remove/Replace/Extract All Caps Phrases}
\usage{
rm_caps_phrase(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_caps_phrase", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_caps_phrae} uses the
\code{rm_caps_phrase} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the all caps strings are extracted
into a list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with "all caps" removed.
}
\description{
Remove/replace/extract 'all caps' phrases containing 1 or more consecutive
upper case letters from a string.  If one word phrase the word must be 3+
letters long.
}
\examples{
x <- c("UGGG! When I use caps I am YELLING!",
   "Or it may mean this is VERY IMPORTANT!",
   "or trying to make a LITTLE SEEM like IT ISN'T LITTLE"
)
rm_caps_phrase(x)
rm_caps_phrase(x, extract=TRUE)
rm_caps_phrase(x, extract=TRUE, trim=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{capital}
\keyword{caps}

