% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_between_2_sigs.R
\name{dist_between_2_sigs}
\alias{dist_between_2_sigs}
\title{Compute the distance between two fatty acid signatures}
\usage{
dist_between_2_sigs(sig_1, sig_2, dist_meas = 1, gamma = 1)
}
\arguments{
\item{sig_1, sig_2}{Equal-length numeric vectors of fatty acid signature
proportions.}

\item{dist_meas}{An integer indicator of the distance measure to compute.
Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure.  See
Details. Default value 1.}
}
\value{
The selected distance between the two signatures.
}
\description{
The utility function \code{dist_between_2_sigs} computes the distance
between two fatty acid signatures.
}
\section{Details}{

This is an internal utility function.  The signatures in \code{sig_1} and
\code{sig_2} are presumed to be ready for analysis, which is best
accomplished by a call to the function \code{\link{prep_sig}}.  Consequently,
to increase execution speed during simulations, no numeric error checking is
performed.  Please refer to documentation for the function
\code{\link{prep_sig}} for additional details.

If the argument \code{dist_meas} is not one of the following integers, a
value of NA is returned:
\itemize{
\item dist_meas == 1 yields the Aitchison distance measure (Stewart et al.
  2014).  This is the default value.
\item dist_meas == 2 yields the Kullback-Leibler distance measure of
  Iverson et al. (2004).
\item dist_meas == 3 yields the chi-square distance measure (Stewart et
  al. 2014).
}

The argument \code{gamma} is only used if \code{dist_meas == 3} and need not
be passed otherwise.  If \code{dist_meas == 3}, \code{gamma} must be greater
than 0 and cannot exceed 1.  If \code{dist_meas == 3} and a value for
\code{gamma} is not passed, a default value of 1 is used.
}

\section{References}{

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
Quantitative fatty acid signature analysis: A new method of
estimating predator diets. \emph{Ecological Monographs} 74:211-235.

Stewart, C., S. Iverson, and C. Field. 2014. Testing for a change in diet
using fatty acid signatures. \emph{Environmental and Ecological
Statistics} 21:775-792.
}

