% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_marker_test.R
\name{pops}
\alias{pops}
\title{Bayesian Polygenic Prioritisation Scoring (Bayesian POPS)}
\usage{
pops(
  stat = NULL,
  sets = NULL,
  validate = NULL,
  threshold = NULL,
  method = "bayesC",
  pi = 0.001,
  nit = 5000,
  nburn = 1000,
  updateB = TRUE,
  updateE = TRUE,
  updatePi = TRUE,
  updateG = TRUE
)
}
\arguments{
\item{stat}{A numeric vector or matrix of summary statistics (e.g., phenotypic values or effect sizes), where rows represent features (e.g., SNPs) and columns represent traits. Required.}

\item{sets}{A list of feature sets (e.g., genes or SNP groups) to map to the rows of `stat`. Required.}

\item{validate}{An optional validation set. If provided, cross-validation results are returned instead of fitting the model.}

\item{threshold}{A numeric value specifying a p-value threshold for feature selection. If provided, only features with p-values below this threshold are included in the model.}

\item{method}{A string specifying the regression method. Options are `"bayesC"` (default), `"bayesR"`, or `"rr"` (ridge regression).}

\item{pi}{A numeric value specifying the proportion of non-zero effects for Bayesian methods. Default is `0.001`.}

\item{nit}{An integer specifying the number of iterations for Bayesian methods. Default is `5000`.}

\item{nburn}{An integer specifying the number of burn-in iterations for Bayesian methods. Default is `1000`.}

\item{updateB}{A logical value indicating whether to update marker effects in Bayesian methods. Default is `TRUE`.}

\item{updateE}{A logical value indicating whether to update residual variances in Bayesian methods. Default is `TRUE`.}

\item{updatePi}{A logical value indicating whether to update the proportion of non-zero effects in Bayesian methods. Default is `TRUE`.}

\item{updateG}{A logical value indicating whether to update the genomic variances in Bayesian methods. Default is `TRUE`.}
}
\value{
A matrix of predicted prioritisation scores (`ypred`) for each feature, ordered by their predictive values. 
If a validation set is provided, cross-validation results are returned instead.
}
\description{
This function performs Polygenic Prioritisation Scoring (POPS) using Bayesian regression (`bayesC` or `bayesR`) or ridge regression (`rr`). 
It maps features to sets, performs optional feature selection based on p-value thresholds, and calculates predictive scores for prioritisation.
}
