% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeQOI.R
\name{writeQOI}
\alias{writeQOI}
\title{Write an QOI image from an RGB(A) raster array or matrix}
\usage{
writeQOI(image, target = raw())
}
\arguments{
\item{image}{\link{matrix} (\strong{required}): Image represented by a integer matrix or array with values in the range of 0 to 255.}

\item{target}{\link{character} or \link{connections} or \link{raw}: Either name of the file to write, a binary connection or a raw vector (raw() - the default - is good enough) indicating that the output should be a raw vector.}
}
\value{
The result is either stored in a file (if target is a file name), in a raw vector (if target is a raw vector) or sent to a binary connection.
}
\description{
Write an QOI image from an RGB(A) raster array or matrix
}
\examples{
## (1) Write to raw() -> see bytes
bin <- writeQOI(Rlogo_RGBA)
rawToChar(head(bin)) ## qoif

\dontrun{
## (2) Write to a *.qoi file
writeQOI(Rlogo_RGBA, "Rlogo_RGBA.qoi")
}
}
\author{
Johannes Friedrich
}
