% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_helpers.R
\name{rename_pattern}
\alias{rename_pattern}
\title{Replace Patterns Inside Variable Names}
\usage{
rename_pattern(data_frame, old_pattern, new_pattern)
}
\arguments{
\item{data_frame}{The data frame in which there are variables to be renamed.}

\item{old_pattern}{The pattern which should be replaced in the variable names.}

\item{new_pattern}{The pattern which should be set in place for the old one.}
}
\value{
Returns a data frame with renamed variables.
}
\description{
Replace a certain pattern inside a variable name with a new one. This can be
used if there are multiple different variable names which have a pattern in
common (e.g. all end in "_sum" but start different), so that there don't have
to be multiple rename variable calls.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Summarise data
all_nested <- my_data |>
    summarise_plus(class      = c(year, sex),
                   values     = c(weight, income),
                   statistics = c("sum", "pct_group", "pct_total", "sum_wgt", "freq"),
                   weight     = weight,
                   nesting    = "deepest",
                   na.rm      = TRUE)

# Rename variables by repacing patterns
new_names <- all_nested |>
    rename_pattern("pct", "percent") |>
    rename_pattern("_sum", "")

}
