% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_new_functions.R
\name{gp_label_portrait}
\alias{gp_label_portrait}
\title{Create a general-purpose (gp) label with text aligned in a portrait orientation.}
\usage{
gp_label_portrait(
  dat,
  wdt = 2,
  hgt = 1,
  page_wdt = 8.5,
  page_hgt = 11,
  top_mar = 0.625,
  bot_mar = 0.625,
  left_mar = 0.625,
  right_mar = 0.625,
  numrow = 8L,
  numcol = 3L,
  filename = "PlotLabel",
  font_sz = 8,
  family = "sans",
  rounded = TRUE,
  bot_txt1 = NULL,
  bot_txt2 = NULL,
  bot_txt3 = NULL,
  cent_txt1 = NULL,
  cent_txt2 = NULL,
  cent_txt3 = NULL,
  cent_txt4 = NULL,
  top_txt1 = NULL,
  top_txt2 = NULL,
  top_txt3 = NULL,
  bot_txt1_id = NULL,
  bot_txt2_id = NULL,
  bot_txt3_id = NULL,
  cent_txt1_id = NULL,
  cent_txt2_id = NULL,
  cent_txt3_id = NULL,
  cent_txt4_id = NULL,
  top_txt1_id = NULL,
  top_txt2_id = NULL,
  top_txt3_id = NULL,
  unique_id = NULL,
  ec_level = 3
)
}
\arguments{
\item{dat}{An input data frame or field book that contains plot attributes.
The order of the columns is not important, and the columns can be any name 
the user desires.}

\item{wdt}{The label width in inches.}

\item{hgt}{The label height in inches.}

\item{page_wdt}{The page width in inches.}

\item{page_hgt}{The page height in inches.}

\item{top_mar}{The page top margin in inches.}

\item{bot_mar}{The page bottom margin in inches.}

\item{left_mar}{The page left margin in inches.}

\item{right_mar}{The page right margin in inches.}

\item{numrow}{The number of label rows per page. It should be an integer.}

\item{numcol}{The number of label columns per page. It should be an integer.}

\item{filename}{A character prefix or path for the pdf file to be created. Default path
is working directory.}

\item{font_sz}{The font size to use.}

\item{family}{The font style to use to print labels.}

\item{rounded}{Set to TRUE if label has round corners; set to false if label has
square corners.}

\item{bot_txt1}{The prefix text for bottom text position 1.}

\item{bot_txt2}{The prefix text for bottom text position 2.}

\item{bot_txt3}{The prefix text for bottom text position 3.}

\item{cent_txt1}{The prefix text for center text position 1.}

\item{cent_txt2}{The prefix text for center text position 2.}

\item{cent_txt3}{The prefix text for center text position 3.}

\item{cent_txt4}{The prefix text for center text position 4.}

\item{top_txt1}{The prefix text for top text position 1.}

\item{top_txt2}{The prefix text for top text position 2.}

\item{top_txt3}{The prefix text for top text position 3.}

\item{bot_txt1_id}{The column identifier in \code{dat} containing text for bottom text position 1.}

\item{bot_txt2_id}{The column identifier in \code{dat} containing text for bottom text position 2.}

\item{bot_txt3_id}{The column identifier in \code{dat} containing text for bottom text position 3.}

\item{cent_txt1_id}{The column identifier in \code{dat} containing text for center text position 1.}

\item{cent_txt2_id}{The column identifier in \code{dat} containing text for center text position 2.}

\item{cent_txt3_id}{The column identifier in \code{dat} containing text for center text position 3.}

\item{cent_txt4_id}{The column identifier in \code{dat} containing text for center text position 4.}

\item{top_txt1_id}{The column identifier in \code{dat} containing text for top text position 1.}

\item{top_txt2_id}{The column identifier in \code{dat} containing text for top text position 2.}

\item{top_txt3_id}{The column identifier in \code{dat} containing text for top text position 3.}

\item{unique_id}{The column identifier in \code{dat} containing unique identifiers or strings to generate QR codes.}

\item{ec_level}{The error correction level (`0` - `3`, lowest to highest) for QR codes.}
}
\value{
A PDF file containing labels affixed with QR codes, saved to the
default or working directory.
}
\description{
This is a standalone function that gives more flexibility to the user to 
design any general-purpose label affixed with QR codes. It gives 10 text 
positions in portrait orientation that can be filled with human-readable text
items as specified by the user. 

This function creates print-ready customized plot labels affixed with QR codes 
given the page setup, label dimensions, the number of rows and columns of labels 
to print per page.
}
\examples{
# Create a general-purpose label in a portrait text orientation based on the 
# 2 x 1 inch Avery 94220 template for laser-jet printers
library(qrlabelr)
df <- data.frame(LOCATION = rep("BAMBEY", 5),
                 PLOT = 1001:1005,
                 ROW = c(rep(1, 3), rep(2, 2)),
                 COLUMN = c(1:3, 1:2),
                 REP = rep(1, 5),
                 IBLOCK = c(rep(1, 3), rep(2, 2)),
                 TREATMENT = paste0("G-", 1:5),
                 SEED_SOURCE = rep("OFF_NUR", 5))

df$ids <- paste0(df$LOCATION,'2023', '_PYT', '_', df$PLOT, '_', df$ROW, '_',
                 df$COLUMN)
file <- tempfile()
\donttest{
if(file.exists(file)) 
gp_label_portrait(
dat = df,
wdt = 2,
hgt = 1,
page_wdt = 8.5,
page_hgt = 11,
top_mar = 0.625,
bot_mar = 0.625,
left_mar = 0.625,
right_mar = 0.625,
numrow = 8L,
numcol = 3L,
filename = file,
font_sz = 10,
family = 'sans',
rounded = TRUE,
bot_txt1 = 'Rubi',
cent_txt2 = 'Rep:',
cent_txt3 = 'R:',
cent_txt4 = 'r:',
top_txt1 = 'P:',
top_txt2 = 'B:',
bot_txt2_id = 'ids',
bot_txt3_id = 'LOCATION',
cent_txt1_id = 'TREATMENT',
cent_txt2_id = 'REP',
cent_txt3_id = 'COLUMN',
cent_txt4_id = 'ROW',
top_txt1_id = 'PLOT',
top_txt2_id = 'IBLOCK',
top_txt3_id = 'SEED_SOURCE',
unique_id = 'ids',
ec_level = 1)
}

}
\seealso{
\code{\link{field_label}} and \code{\link{gp_label}}
}
