% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qsave_handle}
\alias{qsave_handle}
\title{qsave_handle}
\usage{
qsave_handle(x, handle, 
preset = "balanced", algorithm = "lz4", compress_level = 1L, 
shuffle_control = 15L, check_hash=TRUE)
}
\arguments{
\item{x}{the object to serialize.}

\item{handle}{A windows handle external pointer}

\item{preset}{One of "fast", "balanced" (default), "high", "archive", "uncompressed" or "custom".  See details.}

\item{algorithm}{Compression algorithm used: "lz4", "zstd", "lz4hc", "zstd_stream" or "uncompressed".}

\item{compress_level}{The compression level used (Default 1).  For lz4, this number must be > 1 (higher is less compressed).  For zstd, a number between -50 to 22 (higher is more compressed).}

\item{shuffle_control}{An integer setting the use of byte shuffle compression.  A value between 0 and 15 (Default 3).  See details.}

\item{check_hash}{Default TRUE, compute a hash which can be used to verify file integrity during serialization}
}
\value{
the number of bytes serialized (returned invisibly)
}
\description{
Saves an object to a windows handle
}
\details{
This function serializes and compresses an R object to a stream using a file descriptor
If your data is important, make sure you know what happens on the other side of the pipe.  See examples for usage.
}
