% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{qread}
\alias{qread}
\title{qread}
\usage{
qread(file, use_alt_rep=FALSE, strict=FALSE, nthreads=1)
}
\arguments{
\item{file}{The file name/path.}

\item{use_alt_rep}{Use ALTREP when reading in string data (default \code{FALSE}). On R versions prior to 3.5.0, this parameter does nothing.}

\item{strict}{Whether to throw an error or just report a warning (default: \code{FALSE}, i.e. report warning).}

\item{nthreads}{Number of threads to use. Default \code{1}.}
}
\value{
The de-serialized object.
}
\description{
Reads an object in a file serialized to disk.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
        num = rnorm(1e3),
        char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
        stringsAsFactors = FALSE)
myfile <- tempfile()
qsave(x, myfile)
x2 <- qread(myfile)
identical(x, x2) # returns true

# qs support multithreading
qsave(x, myfile, nthreads=2)
x2 <- qread(myfile, nthreads=2)
identical(x, x2) # returns true

# Other examples
z <- 1:1e7
myfile <- tempfile()
qsave(z, myfile)
z2 <- qread(myfile)
identical(z, z2) # returns true

w <- as.list(rnorm(1e6))
myfile <- tempfile()
qsave(w, myfile)
w2 <- qread(myfile)
identical(w, w2) # returns true
}
