% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groebner.R
\name{implicitization}
\alias{implicitization}
\title{Implicitization with Gröbner bases}
\usage{
implicitization(nvariables, parameters, equations, relations)
}
\arguments{
\item{nvariables}{number of variables}

\item{parameters}{character vector of the names of the parameters, or 
\code{NULL} if there's no parameter}

\item{equations}{named list of \code{qspray} polynomials representing the 
parametric equations}

\item{relations}{list of \code{qspray} polynomials representing the relations 
between the variables and between the parameters, or \code{NULL} if there 
is none}
}
\value{
A list of \code{qspray} polynomials.
}
\description{
Implicitization of a system of parametric equations 
  (see example).
}
\examples{
library(qspray)
# ellipse example ####
# variables 
cost <- qlone(1)
sint <- qlone(2)
nvariables <- 2
# parameters
a <- qlone(3)
b <- qlone(4)
parameters <- c("a", "b")
#
equations <- list(
  "x" = a * cost,
  "y" = b * sint
)
relations <- list(
  cost^2 + sint^2 - 1
)
# 
implicitization(nvariables, parameters, equations, relations)
}
