% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_map.R
\name{est_map}
\alias{est_map}
\title{Estimate genetic maps}
\usage{
est_map(
  cross,
  error_prob = 0.0001,
  map_function = c("haldane", "kosambi", "c-f", "morgan"),
  lowmem = FALSE,
  maxit = 10000,
  tol = 0.000001,
  quiet = TRUE,
  save_rf = FALSE,
  cores = 1
)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{error_prob}{Assumed genotyping error probability}

\item{map_function}{Character string indicating the map function to
use to convert genetic distances to recombination fractions.}

\item{lowmem}{If \code{FALSE}, precalculate initial and emission
probabilities, and at each iteration calculate the transition
matrices for a chromosome; potentially a lot faster but using
more memory. Needs to be tailored somewhat to cross type. For
example, multi-way RIL may need to reorder the transition
matrix according to cross order, and AIL and DO need separate
transition matrices for each generation.}

\item{maxit}{Maximum number of iterations in EM algorithm.}

\item{tol}{Tolerance for determining convergence}

\item{quiet}{If \code{FALSE}, print progress messages.}

\item{save_rf}{If \code{TRUE}, save the estimated recombination
fractions as an attribute (\code{"rf"}) of the result.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A list of numeric vectors, with the estimated marker
locations (in cM). The location of the initial marker on each
chromosome is kept the same as in the input \code{cross}.
}
\description{
Uses a hidden Markov model to re-estimate the genetic map for an
experimental cross, with possible allowance for genotyping errors.
}
\details{
The map is estimated assuming no crossover interference,
but a map function (by default, Haldane's) is used to derive the genetic distances.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[,"3"]}
gmap <- est_map(grav2, error_prob=0.002)
}
\keyword{utilities}
