% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_vec.R
\name{batch_vec}
\alias{batch_vec}
\title{Split vector into batches}
\usage{
batch_vec(vec, batch_size = NULL, n_cores = 1)
}
\arguments{
\item{vec}{A vector to be split into batches}

\item{batch_size}{Maximum size for each batch}

\item{n_cores}{Number of compute cores, to be used as a minimum number of batches.}
}
\value{
A list of vectors, each no longer than \code{batch_size}, and with at least \code{n_cores} componenets.
}
\description{
Split a vector into batches, each no longer than \code{batch_size} and
creating at least \code{n_cores} batches, for use in parallel
calculations.
}
\examples{
vec_split <- batch_vec(1:304, 50, 8)
vec_split2 <- batch_vec(1:304, 50)
}
\seealso{
\code{\link[=batch_cols]{batch_cols()}}
}
