% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_scan1.R
\name{subset_scan1}
\alias{subset_scan1}
\alias{subset.scan1}
\title{Subset scan1 output}
\usage{
subset_scan1(x, map = NULL, chr = NULL, lodcolumn = NULL, ...)

\method{subset}{scan1}(x, map = NULL, chr = NULL, lodcolumn = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{"scan1"} as returned by
\code{\link[=scan1]{scan1()}}.}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[=insert_pseudomarkers]{insert_pseudomarkers()}}.}

\item{chr}{Vector of chromosomes.}

\item{lodcolumn}{Vector of integers or character strings indicating the LOD
score columns, either as a numeric indexes or column names.}

\item{...}{Ignored}
}
\value{
Object of class \code{"scan1"}, like the input, but subset by chromosome and/or column. See \code{\link[=scan1]{scan1()}}.
}
\description{
Subset the output of \code{\link[=scan1]{scan1()}} by chromosome or column
}
\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# perform genome scan
out <- scan1(probs, pheno, addcovar=covar, Xcovar=Xcovar)

# pull out chromosome 8
out_c8 <- subset(out, map, chr="8")

# just the second column on chromosome 2
out_c2_spleen <- subset(out, map, "2", "spleen")

# all positions, but just the "liver" column
out_spleen <- subset(out, map, lodcolumn="spleen")
}
