% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probs_qtl2_to_doqtl.R
\name{probs_qtl2_to_doqtl}
\alias{probs_qtl2_to_doqtl}
\title{Convert R/qtl2 genotype probabilities to DOQTL format}
\usage{
probs_qtl2_to_doqtl(probs)
}
\arguments{
\item{probs}{A \code{"calc_genoprob"} object (a list of 3d arrays of
genotype probabilities), as calculated by \code{\link[qtl2:calc_genoprob]{qtl2::calc_genoprob()}}.}
}
\value{
A single three-dimensional array, for use with
\href{https://github.com/dmgatti/DOQTL}{DOQTL}.
}
\description{
Convert R/qtl2 genotype probabilities to DOQTL format
}
\details{
If the arrays in \code{probs} all have 8 columns, they're assumed to be
allele dosages and we paste them all together into one big array.

Otherwise, it should be that the autosomes all have 36 columns the
X chromosome has 44. In this case, the male hemizygotes on the X
are placed where the female homozygotes are, and then we reorder
the genotypes into alphabetical order.
}
