% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_fst_genoprob.R
\name{subset_fst_genoprob}
\alias{subset_fst_genoprob}
\alias{subset.fst_genoprob}
\title{Subsetting genotype probabilities}
\usage{
subset_fst_genoprob(x, ind = NULL, chr = NULL, mar = NULL, ...)

\method{subset}{fst_genoprob}(x, ind = NULL, chr = NULL, mar = NULL, ...)
}
\arguments{
\item{x}{Genotype probabilities as output from \code{\link[=fst_genoprob]{fst_genoprob()}}.}

\item{ind}{A vector of individuals: numeric indices, logical
values, or character string IDs}

\item{chr}{A vector of chromosomes: logical values, or character
string IDs. Numbers are interpreted as character string IDs.}

\item{mar}{A vector of marker names as character string IDs.}

\item{...}{Ignored.}
}
\value{
The input genotype probabilities, with the selected
individuals and/or chromsomes.
}
\description{
Pull out a specified set of individuals and/or chromosomes from
the results of \code{\link[=fst_genoprob]{fst_genoprob()}}.
}
\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
\dontshow{grav2 <- grav2[1:8,c(1,2)]}
pr <- calc_genoprob(grav2)
dir <- tempdir()
fpr <- fst_genoprob(pr, "grav2", dir)

# keep just individuals 1:5, chromosome 2
prsub <- fpr[1:5,2]
# keep just chromosome 2
prsub2 <- fpr[,2]

# clean up: remove all the files we created
unlink(fst_files(fpr))
}
\keyword{utilities}
