% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotScanone.R
\name{iplotScanone}
\alias{iplotScanone}
\title{Interactive LOD curve}
\usage{
iplotScanone(scanoneOutput, cross = NULL, lodcolumn = 1,
  pheno.col = 1, chr = NULL, pxgtype = c("ci", "raw"),
  fillgenoArgs = NULL, chartOpts = NULL, digits = 5)
}
\arguments{
\item{scanoneOutput}{Object of class \code{"scanone"}, as output
from \code{\link[qtl]{scanone}}.}

\item{cross}{(Optional) Object of class \code{"cross"}, see
\code{\link[qtl]{read.cross}}.}

\item{lodcolumn}{Numeric value indicating LOD score column to plot.}

\item{pheno.col}{(Optional) Phenotype column in cross object.}

\item{chr}{(Optional) Vector indicating the chromosomes
for which LOD scores should be calculated. This should be a vector
of character strings referring to chromosomes by name; numeric
values are converted to strings. Refer to chromosomes with a
preceding - to have all chromosomes but those considered. A logical
(TRUE/FALSE) vector may also be used.}

\item{pxgtype}{If phenotype x genotype plot is to be shown, should
it be with means \eqn{\pm}{+/-} 2 SE (\code{"ci"}), or raw
phenotypes (\code{"raw"})?}

\item{fillgenoArgs}{List of named arguments to pass to
\code{\link[qtl]{fill.geno}}, if needed.}

\item{chartOpts}{A list of options for configuring the chart (see
the coffeescript code). Each element must be named using the
corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph of a single-QTL genome scan, as
calculated by \code{\link[qtl]{scanone}}. If \code{cross} is
provided, the LOD curves are linked to a phenotype x genotype plot
for a marker: Click on a marker on the LOD curve and see the
corresponding phenotype x genotype plot.
}
\details{
If \code{cross} is provided, \code{\link[qtl]{fill.geno}}
is used to impute missing genotypes. In this case, arguments to
\code{\link[qtl]{fill.geno}} are passed as a list, for example
\code{fillgenoArgs=list(method="argmax", error.prob=0.002,
map.function="c-f")}.

With \code{pxgtype="raw"}, individual IDs (viewable when hovering
over a point in the phenotype-by-genotype plot) are taken from the
input \code{cross} object, using the \code{\link[qtl]{getid}}
function in R/qtl.
}
\examples{
library(qtl)
data(hyper)
hyper <- calc.genoprob(hyper, step=1)
out <- scanone(hyper)
\donttest{
# iplotScanone with no effects
iplotScanone(out, chr=c(1, 4, 6, 7, 15))}

\donttest{
# iplotScanone with CIs
iplotScanone(out, hyper, chr=c(1, 4, 6, 7, 15))}

\donttest{
# iplotScanone with raw phe x gen
iplotScanone(out, hyper, chr=c(1, 4, 6, 7, 15),
             pxgtype='raw')}

}
\seealso{
\code{\link{iplotMScanone}}, \code{\link{iplotPXG}}, \code{\link{iplotMap}}
}
\keyword{hplot}
