% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotCorr.R
\name{iplotCorr}
\alias{iplotCorr}
\title{Image of correlation matrix with linked scatterplot}
\usage{
iplotCorr(mat, group, rows, cols, reorder = FALSE, corr = stats::cor(mat,
  use = "pairwise.complete.obs"), scatterplots = TRUE, chartOpts = NULL)
}
\arguments{
\item{mat}{Data matrix (individuals x variables)}

\item{group}{Optional vector of groups of individuals (e.g., a genotype)}

\item{rows}{Selected rows of the correlation matrix to include in
the image. Ignored if \code{corr} is provided.}

\item{cols}{Selected columns of the correlation matrix to include
in the image. Ignored if \code{corr} is provided.}

\item{reorder}{If TRUE, reorder the variables by
clustering. Ignored if \code{corr} is provided as a subset of the
overall correlation matrix}

\item{corr}{Correlation matrix (optional).}

\item{scatterplots}{If \code{FALSE}, don't have the heat map be
linked to scatterplots.}

\item{chartOpts}{A list of options for configuring the chart (see
the coffeescript code). Each element must be named using the
corresponding option.}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph with an image of a
correlation matrix linked to underlying scatterplots.
}
\details{
\code{corr} may be provided as a subset of the overall
correlation matrix for the columns of \code{mat}. In this case, the
\code{reorder}, \code{rows} and \code{cols} arguments are ignored. The row and
column names of \code{corr} must match the names of some subset of
columns of \code{mat}.

Individual IDs are taken from \code{rownames(mat)}; they must match
\code{names(group)}.
}
\examples{
data(geneExpr)
\donttest{
iplotCorr(geneExpr$expr, geneExpr$genotype, reorder=TRUE,
          chartOpts=list(cortitle="Correlation matrix",
                         scattitle="Scatterplot"))}

}
\seealso{
\code{\link{iheatmap}}, \code{\link{iplotCurves}}
}
\keyword{hplot}

