% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_area.R
\name{crop_area}
\alias{crop_area}
\title{Crop quadrats based on area}
\usage{
crop_area(
  data,
  row,
  column,
  id,
  dim,
  obs_rm = FALSE,
  obs_range,
  res = FALSE,
  res_dim_x,
  res_dim_y
)
}
\arguments{
\item{data}{A data frame containing annotations, in long format, such that all
observations are contained in one column.}

\item{row}{The column name in \code{data} which contains the row locations of
the annotated points.}

\item{column}{The column name in \code{data} which contains the column location of
the annotated points.}

\item{id}{The column name in \code{data} which contains the quadrat ID for
the annotated points.}

\item{dim}{A vector with length of 2, containing the proportion of the row and
columns to crop. First element will be the proportion of the rows and the
second will be the proportion of the columns.}

\item{obs_rm}{If \code{obs_rm = FALSE}, no quadrats will be removed from the returned
data set. If \code{obs_rm = TRUE}, quadrats will be removed from the returned
data set based on the number of annotated observations in the cropped area
as specified by \code{obs_range}.}

\item{obs_range}{A vector with length of 2, specifying the min and max accepted
number of annotated observations to retain in the data set.}

\item{res}{If \code{res = TRUE} if the dimensions of each quadrat are known. These must
be the same units as the row and column locations. If dimensions are not
known, specify \code{res = FALSE}, and the function will estimate the max dimensions
based off the max row and column location for the annotated points.}

\item{res_dim_x}{The column name in \code{data} which contains the max column dimension
for each quadrat.}

\item{res_dim_y}{The column name in \code{data} which contains the max row dimension
for each quadrat.}
}
\value{
A data frame in of quadrat annotations with a subset of annotated points.
}
\description{
Using the location of annotated points within quadrats and
the size of the quadrat, crop quadrat data to a smaller area, while
maintaining the spatial relationships between points. Useful for making
different sized quadrat data comparable.
}
\examples{
#Creating the data file
tags <- c("Clad", "Sinu", "Sarco", "Loph")

site <- c(rep("Site1", times = 100),
         rep("Site2", times = 100),
         rep("Site3", times = 100),
         rep("Site4", times = 100))
row <- c(sample(x = c(1:2000), size = 100, replace = TRUE),
        sample(x = c(1:2000), size = 100, replace = TRUE),
        sample(x = c(1:2000), size = 100, replace = TRUE),
        sample(x = c(1:2000), size = 100, replace = TRUE))
column <- c(sample(x = c(1:2000), size = 100, replace = TRUE),
           sample(x = c(1:2000), size = 100, replace = TRUE),
           sample(x = c(1:2000), size = 100, replace = TRUE),
           sample(x = c(1:2000), size = 100, replace = TRUE))
label <- c(sample(x = tags, size = 100, replace = TRUE),
          sample(x = tags, size = 100, replace = TRUE),
          sample(x = tags, size = 100, replace = TRUE),
          sample(x = tags, size = 100, replace = TRUE))
coral_annotations <- data.frame(site, row, column, label)

crop_area_coral <- crop_area(data = coral_annotations, row = "row",
                            column = "column", id = "site", dim = c(0.5, 0.5))

coral_annotations$col_dim <- 2000
coral_annotations$row_dim <- 2000

crop_area_coral_2 <- crop_area(data = coral_annotations, row = "row",
                              column = "column", id = "site", dim = c(0.5, 0.5),
                              res = TRUE, res_dim_x = "col_dim", res_dim_y = "row_dim")


}
