% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSurvey.R
\name{getSurvey}
\alias{getSurvey}
\title{Export a survey and download into R}
\usage{
getSurvey(surveyID, root_url, useLabels = TRUE,
  convertStandardColumns = TRUE, lastResponseId = NULL, startDate = NULL,
  endDate = NULL, save_dir = NULL, force_request = FALSE,
  verbose = FALSE)
}
\arguments{
\item{surveyID}{Unique ID for the survey you want to download. Returned as 'id' by the \link[qualtRics]{getSurveys} function.}

\item{root_url}{Base url for your institution (see \url{https://api.qualtrics.com/docs/csv}. You need to supply this url. Your query will NOT work without it.).}

\item{useLabels}{TRUE to export survey responses as Choice Text or FALSE to export survey responses as values}

\item{convertStandardColumns}{logical, defaults to TRUE. If TRUE, then the function will convert general data columns (first name, last name, lat, lon, ip address, startdate, enddate etc.) to their proper format.}

\item{lastResponseId}{Export all responses received after the specified response}

\item{startDate}{Date range filter to only exports responses recorded after the specified date. Accepts dates as character strings in format "YYYY-MM-DD"}

\item{endDate}{Date range filter to only exports responses recorded before the specified date. Accepts dates as character strings in format "YYYY-MM-DD"}

\item{save_dir}{Directory where survey results will be stored. Defaults to a temporary directory which is cleaned when your R session is terminated. This parameter is useful if you'd like to store survey results. The downloaded survey will be stored as an RDS file (see \link[base]{readRDS}).}

\item{force_request}{getSurvey() saves each survey in a temporary directory so that it can quickly be retrieved later. If force_request is TRUE, getSurvey() always downloads the survey from the API instead of loading it from the temporary directory.}

\item{verbose}{Print verbose messages to the R console? Defaults to FALSE}
}
\description{
Export a qualtrics survey you own and import the survey directly into R. NOTE: If you keep getting errors try to use your institution's base URL. See \url{https://api.qualtrics.com/docs/root-url}.
}
\examples{
\dontrun{
registerApiKey("<YOUR-QUALTRICS-API-KEY>")
surveys <- getSurveys("https://leidenuniv.eu.qualtrics.com")
                      # URL is for my own institution.
                      # Substitute with your own institution's url
mysurvey <- getSurvey(surveys$id[6],
                      save_dir = tempdir(),
                      "https://leidenuniv.eu.qualtrics.com",
                      verbose=TRUE)
}
}
\seealso{
See \url{https://api.qualtrics.com/docs/csv} for documentation on the Qualtrics API.
}
\author{
Jasper Ginn
}
