% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSignificant.R
\name{filterSignificant}
\alias{filterSignificant}
\title{filters significant values and returns them as list of data.frames}
\usage{
filterSignificant(foldchange, pvals, labels = NULL, pthresh = 0.05,
  foldchangethresh = 1, biasAdjust = FALSE)
}
\arguments{
\item{foldchange}{log2 fold changes}

\item{pvals}{p values}

\item{labels}{e.g. protein ID's}

\item{pthresh}{pvalue threshold}

\item{foldchangethresh}{fold change threshold}

\item{biasAdjust}{adjustment for p-values}
}
\description{
filters significant values and returns them as list of data.frames
}
\examples{
library(quantable)
foldchange <- rnorm(1000)
pvals <-rexp(1000)
filterSignificant(foldchange, pvals,
 rep("blabla",length(pvals)), pthresh=0.1, foldchangethresh=1)
filterSignificant(foldchange[foldchange>0], pvals[foldchange>0],
 rep("blabla",length(pvals[foldchange>0])), pthresh=0.1, foldchangethresh=1)
filterSignificant(foldchange[foldchange<0], pvals[foldchange<0],
 rep("blabla",length(pvals[foldchange<0])), pthresh=0.1, foldchangethresh=1)
tt <- filterSignificant(foldchange, pvals,
 rep("blabla",length(pvals)), pthresh=0.1, foldchangethresh=10)
}
