% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValuesForVolcano.R
\name{getWRValuesForVolcano}
\alias{getWRValuesForVolcano}
\title{get p-values of wilcoxon rank sum test for volcano}
\usage{
getWRValuesForVolcano(x, y, paired = FALSE, adjust = TRUE)
}
\arguments{
\item{x}{- one data matrix}

\item{y}{- second data matrix}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{adjust}{pvalues using Benjamin Hochberg}
}
\value{
list with two fields fchange (fold change) and pval
}
\description{
get p-values of wilcoxon rank sum test for volcano
}
\examples{
a <- t(replicate(200,rnorm(20,runif(1,-3,3),1)))
b <- a[1:100,]
a <- a[101:200,]
boxplot(t(a[1:20,]))
boxplot(t(b[1:20,]))
res <- getWRValuesForVolcano(a,b)
volcanoplot(res$fchange , res$pval)
}
