% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/corpus.R, R/textfile.R
\name{texts}
\alias{texts}
\alias{texts.character}
\alias{texts.corpus}
\alias{texts.corpusSource}
\title{get corpus texts}
\usage{
texts(x, groups = NULL, ...)

\method{texts}{corpus}(x, groups = NULL, ...)

\method{texts}{character}(x, groups = NULL, ...)

\method{texts}{corpusSource}(x, groups = NULL, ...)
}
\arguments{
\item{x}{A quanteda corpus object}

\item{groups}{character vector containing the names of document variables in
a corpus, or a factor equal in length to the number of documents, used for
aggregating the texts through concatenation.  If \code{x} is of type character,
then \code{groups} must be a factor.}

\item{...}{unused}
}
\value{
For \code{texts}, a character vector of the texts in the corpus.

  For \code{texts <-}, the corpus with the updated texts.
}
\description{
Get the texts in a quanteda corpus object, with grouping options.  Works for plain character
vectors too, if \code{groups} is a factor.
}
\examples{
nchar(texts(subset(inaugCorpus, Year < 1806)))

# grouping on a document variable
nchar(texts(subset(inaugCorpus, Year < 1806), groups = "President"))

# grouping a character vector using a factor
nchar(inaugTexts[1:5])
nchar(texts(inaugTexts[1:5], groups = as.factor(inaugCorpus[1:5, "President"])))
}

