% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textfile.R
\docType{methods}
\name{textfile}
\alias{textfile}
\alias{textfile,character,index,ANY,missing,missing,missing-method}
\alias{textfile,character,missing,ANY,character,ANY,ANY-method}
\alias{textfile,character,missing,ANY,missing,missing,missing-method}
\title{read a text corpus source from a file}
\usage{
textfile(file, textField, cache = FALSE, docvarsfrom = c("filenames"),
  dvsep = "_", docvarnames = NULL, ...)

\S4method{textfile}{character,index,ANY,missing,missing,missing}(file,
  textField, cache = FALSE, docvarsfrom = c("filenames"), dvsep = "_",
  docvarnames = NULL, ...)

\S4method{textfile}{character,missing,ANY,missing,missing,missing}(file,
  textField, cache = FALSE, docvarsfrom = c("filenames"), dvsep = "_",
  docvarnames = NULL, ...)

\S4method{textfile}{character,missing,ANY,character,ANY,ANY}(file,
  textField = NULL, cache = FALSE, docvarsfrom = c("headers"),
  dvsep = "_", docvarnames = NULL, ...)
}
\arguments{
\item{file}{the complete filename(s) to be read.  The value can be a vector 
of file names, a single file name, or a file "mask" using a "glob"-type 
wildcard value.  Currently available file value types are: \describe{ 
\item{\code{txt}}{plain text files} \item{\code{json}}{data in JavaScript 
Object Notation, consisting of the texts and additional document-level 
variables and document-level meta-data.  The text key must be identified by
specifying a \code{textField} value.} \item{\code{csv}}{comma separated 
value data, consisting of the texts and additional document-level variables
and document-level meta-data.  The text file must be identified by 
specifying a \code{textField} value.} \item{\code{tab, tsv}}{tab-separated 
value data, consisting of the texts and additional document-level variables
and document-level meta-data.  The text file must be identified by 
specifying a \code{textField} value.} \item{a wildcard value}{any valid 
pathname with a wildcard ("glob") expression that can be expanded by the 
operating system.  This may consist of multiple file types.} 
\item{\code{xml}}{Basic flat XML documents are supported -- those of the 
kind supported by the function xmlToDataFrame function of the \strong{XML} 
package.} \item{\code{zip}}{zip archive file, containing \code{*.txt} 
files.  This may be a URL to a zip file.} }}

\item{textField}{a variable (column) name or column number indicating where 
to find the texts that form the documents for the corpus.  This must be 
specified for file types \code{.csv} and \code{.json}.}

\item{cache}{If \code{TRUE}, write the object to a temporary file and store 
the temporary filename in the \link{corpusSource-class} object definition. 
If \code{FALSE}, return the data in the object. Caching the file provides a
way to read in very large quantities of textual data without storing two 
copies in memory: one as a \link{corpusSource-class} object and the second 
as a \link{corpus} class object.  It also provides a way to try different 
settings of encoding conversion when creating a corpus from a 
\link{corpusSource-class} object, without having to load in all of the 
source data again.}

\item{docvarsfrom}{used to specify that docvars should be taken from the 
filenames, when the \code{textfile} inputs are filenames and the elements 
of the filenames are document variables, separated by a delimiter 
(\code{dvsep}).  This allows easy assignment of docvars from filenames such
as \code{1789-Washington.txt}, \code{1793-Washington}, etc. by \code{dvsep}
or from meta-data embedded in the text file header (\code{headers}).}

\item{dvsep}{separator used in filenames to delimit docvar elements if 
\code{docvarsfrom="filenames"} is used}

\item{docvarnames}{character vector of variable names for \code{docvars}, if 
\code{docvarsfrom} is specified.  If this argument is not used, default 
docvar names will be used (\code{docvar1}, \code{docvar2}, ...).}

\item{...}{additional arguments passed through to low-level file reading
function, such as \code{\link{file}}, \code{\link{read.csv}}, etc.  Useful
for specifying an input encoding option, which is specified in the same was
as it would be give to \code{\link{iconv}}.  See the Encoding section of
\link{file} for details.}
}
\value{
an object of class \link{corpusSource-class} that can be read by 
  \link{corpus} to construct a corpus
}
\description{
Read a text corpus from a source file, where the single file will consist of 
a set of texts in columns and document variables and document-level meta-data
in additional columns.  For spreadsheet-like files, the first row must be a 
header.
}
\details{
The constructor does not store a copy of the texts, but rather reads
  in the texts and associated data, and saves them to a temporary disk file 
  whose location is specified in the \link{corpusSource-class} object.  This 
  prevents a complete copy of the object from cluttering the global 
  environment and consuming additional space.  This does mean however that 
  the state of the file containing the source data will not be cross-platform
  and may not be persistent across sessions.  So the recommended usage is to 
  load the data into a corpus in the same session in which \code{textfile} is
  called.
}
\examples{
\dontrun{# Twitter json
mytf1 <- textfile("http://www.kenbenoit.net/files/tweets.json")
summary(corpus(mytf1), 5)
# generic json - needs a textField specifier
mytf2 <- textfile("http://www.kenbenoit.net/files/sotu.json",
                  textField = "text")
summary(corpus(mytf2))
# text file
mytf3 <- textfile(unzip(system.file("extdata", "pg2701.txt.zip", package = "quanteda")))
summary(corpus(mytf3))
# XML data
mytf6 <- textfile("http://www.kenbenoit.net/files/plant_catalog.xml", 
                  textField = "COMMON")
summary(corpus(mytf6))
# csv file
write.csv(data.frame(inaugSpeech = texts(inaugCorpus), docvars(inaugCorpus)), 
          file = "/tmp/inaugTexts.csv", row.names = FALSE)
mytf7 <- textfile("/tmp/inaugTexts.csv", textField = "inaugSpeech")
summary(corpus(mytf7))

# vector of full filenames for a recursive structure
textfile(list.files(path = "~/Desktop/texts", pattern = "\\\\.txt$", 
                    full.names = TRUE, recursive = TRUE))
}
}
\author{
Kenneth Benoit and Paul Nulty
}

