% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toLower.R
\name{toLower}
\alias{toLower}
\alias{toLower.NULL}
\alias{toLower.character}
\alias{toLower.corpus}
\alias{toLower.tokenizedTexts}
\alias{toUpper}
\alias{toUpper.NULL}
\alias{toUpper.character}
\alias{toUpper.corpus}
\alias{toUpper.tokenizedTexts}
\title{Convert texts to lower (or upper) case}
\usage{
toLower(x, keepAcronyms = FALSE, ...)

\method{toLower}{character}(x, keepAcronyms = FALSE, ...)

\method{toLower}{NULL}(x, ...)

\method{toLower}{tokenizedTexts}(x, keepAcronyms = FALSE, ...)

\method{toLower}{corpus}(x, keepAcronyms = FALSE, ...)

toUpper(x, ...)

\method{toUpper}{character}(x, ...)

\method{toUpper}{NULL}(x, ...)

\method{toUpper}{tokenizedTexts}(x, ...)

\method{toUpper}{corpus}(x, ...)
}
\arguments{
\item{x}{texts to be lower-cased (or upper-cased)}

\item{keepAcronyms}{if \code{TRUE}, do not lowercase any all-uppercase words.
Only applies to \code{toLower}.}

\item{...}{additional arguments passed to \pkg{stringi} functions, (e.g. 
\code{\link{stri_trans_tolower}}), such as \code{locale}}
}
\value{
Texts tranformed into their lower- (or upper-)cased versions.  If \code{x} is a 
  character vector or a corpus, return a character vector.  If 
  \code{x} is a list of tokenized texts, then return a list of 
  tokenized texts.
}
\description{
Convert texts or tokens to lower (or upper) case
}
\examples{
test1 <- c(text1 = "England and France are members of NATO and UNESCO", 
           text2 = "NASA sent a rocket into space.")
toLower(test1)
toLower(test1, keepAcronyms = TRUE)

test2 <- tokenize(test1, removePunct=TRUE)
toLower(test2)
toLower(test2, keepAcronyms = TRUE)
test1 <- c(text1 = "England and France are members of NATO and UNESCO", 
           text2 = "NASA sent a rocket into space.")
toUpper(test1)

test2 <- tokenize(test1, removePunct = TRUE)
toUpper(test2)
}

