% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus-methods-base.R
\name{head.corpus}
\alias{head.corpus}
\alias{tail.corpus}
\title{Return the first or last part of a corpus}
\usage{
\method{head}{corpus}(x, n = 6L, ...)

\method{tail}{corpus}(x, n = 6L, ...)
}
\arguments{
\item{x}{a dfm object}

\item{n}{a single integer.  If positive, the number of documents for the
resulting object: number of first/last documents for the dfm.  If negative,
all but the n last/first number of documents of x.}

\item{...}{additional arguments passed to other functions}
}
\value{
A \link{corpus} class object corresponding to the subset defined 
  by \code{n}.
}
\description{
For a \link{corpus} object, returns the first or last \code{n} documents.
}
\examples{
head(data_corpus_irishbudget2010, 3) \%>\% summary()

tail(data_corpus_irishbudget2010, 3) \%>\% summary()
}
\keyword{corpus}
