% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_nb.R
\name{predict.textmodel_nb}
\alias{predict.textmodel_nb}
\title{Prediction from a fitted textmodel_nb object}
\usage{
\method{predict}{textmodel_nb}(
  object,
  newdata = NULL,
  type = c("class", "probability", "logposterior"),
  force = FALSE,
  ...
)
}
\arguments{
\item{object}{a fitted Naive Bayes textmodel}

\item{newdata}{dfm on which prediction should be made}

\item{type}{the type of predicted values to be returned; see Value}

\item{force}{make newdata's feature set conformant to the model terms}

\item{...}{not used}
}
\value{
\code{predict.textmodel_nb} returns either a vector of class
  predictions for each row of \code{newdata} (when \code{type = "class"}), or
  a document-by-class matrix of class probabilities (when \code{type =
  "probability"}) or log posterior likelihoods (when \code{type =
  "logposterior"}).
}
\description{
\code{predict.textmodel_nb()} implements class predictions from a fitted
Naive Bayes model. using trained Naive Bayes examples
}
\examples{
# application to LBG (2003) example data
(tmod <- textmodel_nb(data_dfm_lbgexample, y = c("A", "A", "B", "C", "C", NA)))
predict(tmod)
predict(tmod, type = "logposterior")
}
\seealso{
\code{\link{textmodel_nb}}
}
\keyword{internal}
\keyword{textmodel}
