% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus-methods-base.R
\name{summary.corpus}
\alias{summary.corpus}
\title{Summarize a corpus}
\usage{
\method{summary}{corpus}(object, n = 100, tolower = FALSE, showmeta = TRUE, ...)
}
\arguments{
\item{object}{corpus to be summarized}

\item{n}{maximum number of texts to describe, default=100}

\item{tolower}{convert texts to lower case before counting types}

\item{showmeta}{set to \code{TRUE} to include document-level
meta-data}

\item{...}{additional arguments passed through to \code{\link[=tokens]{tokens()}}}
}
\description{
Displays information about a corpus, including attributes and metadata such
as date of number of texts, creation and source.
}
\examples{
summary(data_corpus_inaugural)
summary(data_corpus_inaugural, n = 10)
corp <- corpus(data_char_ukimmig2010,
               docvars = data.frame(party=names(data_char_ukimmig2010)))
summary(corp, showmeta = TRUE) # show the meta-data
sumcorp <- summary(corp) # (quietly) assign the results
sumcorp$Types / sumcorp$Tokens # crude type-token ratio
}
\keyword{corpus}
\keyword{internal}
