% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lossfun.R
\name{lossfun}
\alias{lossfun}
\title{Loss Functions}
\usage{
lossfun(obj = list(loss = NULL, ES = NULL), beta = 1e-04)
}
\arguments{
\item{obj}{a list that contains the following elements:
\describe{
\item{\code{loss}}{a numeric vector that contains the values of a loss series
ordered from past to present; is set to \code{NULL} by default}
\item{\code{ES}}{a numeric vector that contains the estimated values of the
ES for the same time points of the loss series \code{loss}; is set to
\code{NULL} by default}
}
Please note that a list returned by the \code{rollcast} function can be directly
passed to \code{lossfun}.}

\item{beta}{a single numeric value; a measure for the opportunity cost of
capital; default is \code{1e-04}.}
}
\value{
an S3 class object, which is a list of
\describe{
\item{loss.func1}{regulatory loss function}
\item{loss.func2}{firm's loss function following Sarma et al. (2003)}
\item{loss.func3}{loss function following Abad et al. (2015)}
\item{loss.func4}{Feng's loss function; a compromise of regulatory and
firm's loss function}
}
}
\description{
This functions allows for the calculation of loss functions in order to assess
the performance of models in regard to forecasting ES.
}
\details{
Given a negative return series \code{obj$loss}, the corresponding Expected
Shortfall (ES) estimates \code{obj$ES} and a parameter \code{beta} that
defines the opportunity cost of capital, four different definitions of loss
functions are considered.
}
\examples{

prices <- DAX$price.close
returns <- diff(log(prices))
n <- length(returns)
nout <- 250 # number of obs. for out-of-sample forecasting
nwin <- 500 # window size for rolling forecasts
results <- rollcast(x = returns, p = 0.975, method = 'age', nout = nout,
                     nwin = nwin)
loss <- -results$xout
ES <- results$ES
loss.data <- list(loss = loss, ES = ES)
lossfun(loss.data)

# directly passing the output object of 'rollcast()' to 'lossfun()'
lossfun(results)

}
\references{
Abad, P., Muela, S. B., & Martín, C. L. (2015). The role of the loss function
in value-at-risk comparisons. The Journal of Risk Model Validation, 9(1), 1-19.

Sarma, M., Thomas, S., & Shah, A. (2003). Selection of Value-at-Risk models.
Journal of Forecasting, 22(4), 337-358.
}
