% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_outliers.R
\name{detect_outliers}
\alias{detect_outliers}
\title{Detect Anomalies in a Data Frame}
\usage{
detect_outliers(data, column, method = "zscore", threshold = 3)
}
\arguments{
\item{data}{A data frame containing the data to analyze.}

\item{column}{A string specifying the name of the numeric column to analyze.}

\item{method}{A character string. "zscore" or "iqr". Defaults to "zscore".}

\item{threshold}{A numeric value. The cutoff limit. Defaults to 3 for "zscore" and 1.5 for "iqr".}
}
\value{
A data frame containing only the rows considered outliers, with an additional column displaying the calculated score or bounds.
}
\description{
This function identifies rows containing outliers in a specific numeric column.
It supports two methods:
\itemize{
\item \strong{zscore}: Based on the standard deviation (statistical approach). Best for normal distributions.
\item \strong{iqr}: Based on the Interquartile Range (robust approach). Best for data with skewness or extreme outliers.
}
}
\examples{
# Example with a clear outlier
df <- data.frame(
  id = 1:6,
  value = c(10, 12, 11, 10, 500, 11)
)

# Detect using IQR (Robust)
detect_outliers(df, column = "value", method = "iqr")

# Detect using Z-Score
detect_outliers(df, column = "value", method = "zscore")
}
